/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api.visualization;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import de.z0rdak.yawp.core.area.TextDisplayProperties;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3169;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_8113;

public final class VisualizationUtil {
    private VisualizationUtil() {
    }

    public static void updateDisplayBlock(class_1297 blockDisplayEntity, class_2960 blockRl) {
        if (!(blockDisplayEntity instanceof class_8113.class_8115)) {
            throw new IllegalArgumentException("BlockDisplay entity is not a Display.BlockDisplay");
        }
        class_3169 entityDataAccessor = new class_3169(blockDisplayEntity);
        class_2487 entityTag = entityDataAccessor.method_13881();
        class_2487 blockState = entityTag.method_10562("block_state");
        blockState.method_10582("Name", blockRl.toString());
        entityTag.method_10566("block_state", (class_2520)blockState);
        try {
            entityDataAccessor.method_13880(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void updateDisplayGlow(class_1297 blockDisplayEntity, boolean glow) {
        if (!(blockDisplayEntity instanceof class_8113.class_8115)) {
            throw new IllegalArgumentException("BlockDisplay entity is not a Display.BlockDisplay");
        }
        class_3169 entityDataAccessor = new class_3169(blockDisplayEntity);
        class_2487 entityTag = entityDataAccessor.method_13881();
        entityTag.method_10556("Glowing", glow);
        try {
            entityDataAccessor.method_13880(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void updateDisplayLightLevel(class_1297 blockDisplayEntity, int lightLevel) {
        if (!(blockDisplayEntity instanceof class_8113.class_8115)) {
            throw new IllegalArgumentException("BlockDisplay entity is not a Display.BlockDisplay");
        }
        class_3169 entityDataAccessor = new class_3169(blockDisplayEntity);
        class_2487 entityTag = entityDataAccessor.method_13881();
        class_2487 brightnessTag = new class_2487();
        brightnessTag.method_10569("sky", lightLevel);
        brightnessTag.method_10569("block", lightLevel);
        entityTag.method_10566("brightness", (class_2520)brightnessTag);
        try {
            entityDataAccessor.method_13880(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void updateDisplayProperties(class_1297 blockDisplayEntity, BlockDisplayProperties properties) {
        class_3169 entityDataAccessor = new class_3169(blockDisplayEntity);
        class_2487 entityTag = entityDataAccessor.method_13881();
        class_2487 blockState = entityTag.method_10562("block_state");
        blockState.method_10582("Name", properties.blockRl().toString());
        entityTag.method_10566("block_state", (class_2520)blockState);
        entityTag.method_10556("Glowing", properties.hasGlow());
        class_2487 brightnessTag = new class_2487();
        brightnessTag.method_10569("sky", properties.lightLevel());
        brightnessTag.method_10569("block", properties.lightLevel());
        entityTag.method_10566("brightness", (class_2520)brightnessTag);
        try {
            entityDataAccessor.method_13880(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static class_1297 createBlockDisplayRecursive(class_3218 level, class_2338 pos, class_2487 displayTag) {
        return class_1299.method_17842((class_2487)displayTag, (class_1937)level, p_396566_ -> {
            p_396566_.method_5808((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), p_396566_.method_36454(), p_396566_.method_36455());
            return p_396566_;
        });
    }

    public static Optional<class_1297> createDisplayEntity(class_3218 level, class_2338 pos, class_2487 displayTag) {
        Optional entity = class_1299.method_5892((class_2487)displayTag, (class_1937)level);
        entity.ifPresent(e -> e.method_5808((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), e.field_5982, e.field_6004));
        return entity;
    }

    public static Optional<class_1297> createTextDisplayEntity(class_3218 level, String regionName, class_2338 pos, TextDisplayProperties displayProperties) {
        class_2487 entityTag = VisualizationUtil.buildTeleportAnchorTextDisplayTag(regionName, displayProperties);
        Optional maybeEntity = class_1299.method_5892((class_2487)entityTag, (class_1937)level);
        maybeEntity.ifPresent(e -> e.method_5808((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), e.field_5982, e.field_6004));
        return maybeEntity;
    }

    public static Optional<class_1297> createBlockDisplayEntity(class_3218 level, String regionName, class_2338 pos, BlockDisplayProperties displayProperties) {
        class_2487 entityTag = VisualizationUtil.buildBlockDisplayTag(regionName, displayProperties);
        Optional maybeEntity = class_1299.method_5892((class_2487)entityTag, (class_1937)level);
        maybeEntity.ifPresent(e -> e.method_5808((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), e.field_5982, e.field_6004));
        return maybeEntity;
    }

    public static class_2487 buildTeleportAnchorTextDisplayTag(String regionName, TextDisplayProperties properties) {
        class_2487 textDisplayTag = new class_2487();
        class_2960 blockDisplayRl = class_2960.method_60656((String)"text_display");
        textDisplayTag.method_10582("id", blockDisplayRl.toString());
        class_2487 data = new class_2487();
        data.method_10582("yawp_display", "text");
        data.method_10582("region", regionName);
        data.method_10582("tpAnchor", properties.getText());
        textDisplayTag.method_10566("data", (class_2520)data);
        class_2487 brightnessTag = new class_2487();
        brightnessTag.method_10569("sky", 15);
        brightnessTag.method_10569("block", 15);
        textDisplayTag.method_10566("brightness", (class_2520)brightnessTag);
        textDisplayTag.method_10582("billboard", "center");
        class_5250 text = class_2561.method_43470((String)properties.toString());
        textDisplayTag.method_10582("text", text.toString());
        textDisplayTag.method_10582("alignment", "center");
        textDisplayTag.method_10569("background", 0x1A000000);
        return textDisplayTag;
    }

    public static class_2487 buildBlockDisplayTag(String regionName, BlockDisplayProperties properties) {
        class_2487 blockDisplayTag = new class_2487();
        class_2960 blockDisplayRl = class_2960.method_60656((String)"block_display");
        blockDisplayTag.method_10582("id", blockDisplayRl.method_12832());
        blockDisplayTag.method_10556("Glowing", properties.hasGlow());
        class_2487 data = new class_2487();
        data.method_10582("yawp_display", "block");
        data.method_10582("region", regionName);
        blockDisplayTag.method_10566("data", (class_2520)data);
        class_2487 brightnessTag = new class_2487();
        brightnessTag.method_10569("sky", properties.lightLevel());
        brightnessTag.method_10569("block", properties.lightLevel());
        blockDisplayTag.method_10566("brightness", (class_2520)brightnessTag);
        class_2487 blockstateTag = new class_2487();
        blockstateTag.method_10582("Name", properties.blockRl().toString());
        blockDisplayTag.method_10566("block_state", (class_2520)blockstateTag);
        return blockDisplayTag;
    }
}

